#!/usr/bin/python3.8

import locale
locale.setlocale(locale.LC_ALL, '')
import random
import curses
import time
import os

signals_max = 2
try:
	from playsound import playsound
	signals_max = 3
except:
	pass
	"""
	module for tone(frequency,duration)
	signals_max = 4
	"""

# ---------------- Globals ----------------

class Char:
	ctrl_p =  16
	esc = 27
	p = 112
	digits = ['0','1','2','3','4','5','6','7','8','9']
	delayadd = [chr(curses.KEY_UP),chr(curses.KEY_RIGHT),chr(curses.KEY_PPAGE),chr(curses.KEY_IC)]
	delaysub = [chr(curses.KEY_DOWN),chr(curses.KEY_LEFT),chr(curses.KEY_NPAGE),chr(curses.KEY_DC)]
	delay_keys = delayadd+delaysub+digits
	delaysteps = [1e4,1e5,1e6,1e7,1e8]

class Globals:
	delay = 0
	xmin = 0
	ymin = 0
	abs_xmax = 0
	abs_ymax = 0
	xmax = 0
	ymax = 0
	lines = 0
	posmax = 0
	tempcomps = 0
	tempplots = 0
	start = 0
	presort = 0
	shell_step = 1.45
	presort_type = ['Random','Ascending','Descending']
	presorts = len(presort_type)
	sortarray = []
	merge_area = []
	key = ''

	minx=90
	miny=36

	sort_names = [
	'Insert',
	'Odd-Even',
	'Cycle',
	'Bubble',
	'DoubleBubble',
	'Select',
	'Heap',
	'Merge',
	'Shell(Bubble)',
	'Shell(insert)',
	'Quick',
	'Radix',
	'Count',
	'No ',
	]
	sorts = len(sort_names)
	sort_keys = 'abcdefghijklmnopqrstuvwxyz'[:sorts]
	sorttimes = []
	plots = [0]*sorts
	compares = [0]*sorts

	namepos = 25
	infopos = 50
	prepos  = 70

	signal = 1
	durations = [0,0,0.8,5]
	alert = '/media/bertel/Terabyte/Utility/tada.wav'
	frequency = 1000

# ---------------- Functions ----------------

def wait_menu (leave=0):
	display.addstr(0,Globals.infopos,' Press [Space] ',curses.A_REVERSE)
	display.refresh()
	key=''
	while key!=32:
		key=display.getch()
		if key==Char.ctrl_p: # For test purposes.
			do_presort(1) # If this changes the screen - the sort failed!
			display.addstr(0,Globals.infopos,' [Checkscreen] ',curses.A_REVERSE)
	if leave:
		display.clear()
		return
	display.addstr(0,Globals.infopos,'Quit: [Home]')
	display.refresh()

def sec_format (nasec):
	return '{:.3f} sec.'.format(nasec/1000000000)

def time_format (nasec):
	secs=nasec/1e9
	mins=secs//60
	secs%=60
	if mins:
		return '{:.0f}:{:06.3f}'.format(mins,secs)
	return '{:6.3f}'.format(secs)

def delay_routine ():
	timer=time.perf_counter_ns()
	while time.perf_counter_ns()-timer<Globals.delay:
		Globals.key=display.getch()
		if Globals.key==curses.KEY_HOME:
			return
		if Globals.key==Char.p:
			display.addstr(0,Globals.infopos,'   Pause    ',curses.A_REVERSE)
			display.refresh()
			key=0
			while key!=Char.p:
				key=display.getch()
		display.addstr(0,Globals.infopos,'Quit: [Home]')

def set_delay ():
	if ch in Char.delayadd:
		level=Char.delayadd.index(ch)
		Globals.delay+=Char.delaysteps[level]
		return
	if ch in Char.delaysub:
		level=Char.delaysub.index(ch)
		step=Char.delaysteps[level]
		if Globals.delay>=step:
			Globals.delay-=step
		return
	if ch in Char.digits:
		Globals.delay=Char.digits.index(ch)*Char.delaysteps[-1]

def signal_action ():
	if Globals.signal==0:
		return
	if Globals.signal==1:
		curses.flash()
		return
	if Globals.signal==2 and signals_max==3:
		playsound(Globals.alert)
		return
	# play_tone(Globals.frequency,Globals.duration)

def preplot (pos,val):
	y=pos//Globals.xmax+2
	x=pos%Globals.xmax+2
	display.addstr(y,x,val)

def plot (pos,val):
	y=pos//Globals.xmax+2
	x=pos%Globals.xmax+2
	display.addstr(y,x,val)
	Globals.tempplots+=1
	if Globals.delay:
		delay_routine()

def read_plot (pos):
	y=pos//Globals.xmax+2
	x=pos%Globals.xmax+2
	return chr(display.inch(y,x))

# ---------------- Init ----------------

def init_screendata (ch=0):
	if ch=='+':
		if Globals.lines<Globals.ymax:
			Globals.lines+=1
	elif ch=='-':
		if Globals.lines>1:
			Globals.lines-=1
	xdif=Globals.xmax-Globals.xmin
	ydif=Globals.lines-Globals.ymin
	Globals.posmax=xdif*ydif

def fill_sortarray ():
#	random.seed(314159) # Use if each new run must use the same set of screen data.
# Once the script is running, the screen data set remains the same.
	sortarray=[]
	for pos in range(Globals.posmax):
		if random.random()>=.5:
			sortarray.append(chr(random.randrange(33,128)))
		else:
			sortarray.append(chr(random.randrange(160,256)))
	return sortarray

def init_screen ():
	display=curses.initscr()
	curses.curs_set(0)
	curses.noecho()
	display.keypad(1)
	Globals.abs_ymax,Globals.abs_xmax=display.getmaxyx()
	if Globals.abs_ymax<Globals.miny or Globals.abs_xmax<Globals.minx:
		curses.endwin()
		input(' The window is too small! Make it at least ({},{})\n and then press [Enter] ...'.format(Globals.minx,Globals.miny))
		return init_screen()
	Globals.xmax=Globals.abs_xmax-4
	Globals.ymax=Globals.abs_ymax-5
	Globals.lines=Globals.ymax
	init_screendata()
	Globals.sortarray=fill_sortarray()
	zero_data()
	Globals.merge_area=[0]*Globals.posmax
	return display

def fill_screen ():
	for pos in range(Globals.posmax):
		preplot(pos,Globals.sortarray[pos])
	# Total mystery! - an unexplained questionmark must be removed.
	for y in range(2,Globals.ymax+2):
		display.addstr(y,Globals.xmax+2,' ')
	display.refresh()

def zero_data ():
	Globals.sorttimes=[]
	for y in range(Globals.sorts):
		temp=[]
		for x in range(Globals.presorts):
			temp.append('.000')
		Globals.sorttimes.append(temp)
	for sort in range(Globals.sorts):
		Globals.plots[sort]=0
		Globals.compares[sort]=0

# ---------------- Display functions ----------------

def display_delay (menu=0):
	if Globals.delay:
		return ' Delay: {:.2f} msec\n'.format(Globals.delay/1e6)
	if menu:
		return ' Delay: 0 (No pause, no quit)\n'
	else:
		return ' Delay: 0\n'

def display_signal ():
	if Globals.signal==0:
		return ' [S]	No signal\n'
	elif Globals.signal==1:
		return ' [S]	Flash screen\n'
	elif Globals.signal==2:
		if signals_max==3:
			return ' [S]	Play sound-file\n'
	Globals.duration=Globals.durations[Globals.signal]
	return ' [S]	Sound duration: {:.1f} sec\n'.format(Globals.duration)

def display_info (sort):
	display.addstr(0,2,display_delay())
	print(' Sort number: ',sort)
	display.addstr(0,Globals.namepos,Globals.sort_names[sort]+'sort')
	if (Globals.delay):
		display.addstr(0,Globals.infopos,'Quit: [Home]')
	display.addstr(0,Globals.prepos,'Presort: '+Globals.presort_type[Globals.presort])
	display.refresh()

def report_status ():
	tim=time_format(time.perf_counter_ns()-Globals.start)
	display.addstr(0,2,'Time: {:14}'.format(tim))
	plt='{:n}'.format(Globals.tempplots).replace(".","'")
	cop='{:n}'.format(Globals.tempcomps).replace(".","'")
	temp='Plots: {}     Compares: {}'.format(plt,cop)
	display.addstr(Globals.lines+3,2,temp)
	display.refresh()
	Globals.sorttimes[sort][Globals.presort]=tim
	Globals.plots[sort]=plt
	Globals.compares[sort]=cop
	signal_action ()
	curses.flushinp()
	wait_menu(1)

# ---------------- Sorting routines ----------------

def do_presort (ps): # Countsort
	if not ps:
		return
	counter=[0]*Globals.posmax
	for pos in range(Globals.posmax):
		counter[ord(read_plot(pos))]+=1
	pos=0
	if ps==1:
		for nr in range(256):
			for n in range(counter[nr]):
				preplot(pos,chr(nr))
				pos+=1
	elif ps==2:
		for nr in range(255,-1,-1):
			for n in range(counter[nr]):
				preplot(pos,chr(nr))
				pos+=1
	display.refresh()

def odd_even_sort ():
	byt=1
	while byt:
		byt=0
		for begin in [1,0]:
			for i in range(begin,Globals.posmax-1,2):
				Globals.tempcomps+=1
				if read_plot(i)>read_plot(i+1):
					temp=read_plot(i)
					plot(i,read_plot(i+1))
					plot(i+1,temp)
					byt=1
					display.refresh()
				if Globals.key==curses.KEY_HOME:
					return

def bubblesort ():
	for pos1 in range(Globals.posmax-1):
		key1=read_plot(pos1)
		for pos2 in range(pos1+1,Globals.posmax):
			key2=read_plot(pos2)
			Globals.tempcomps+=1
			if key2<key1:
				plot(pos1,key2)
				plot(pos2,key1)
				display.refresh()
				key1=key2
				if Globals.key==curses.KEY_HOME:
					return

def insertsort ():
	for pos0 in range(1,Globals.posmax):
		key=read_plot(pos0)
		pos=pos0-1
		while pos>=0 and read_plot(pos)>key:
			Globals.tempcomps+=1
			plot(pos+1,read_plot(pos))
			display.refresh()
			pos-=1
			if Globals.key==curses.KEY_HOME:
				return
		plot(pos+1,key)
		display.refresh()

def cyclesort ():
	for pos1 in range(Globals.posmax-1):
		value=read_plot(pos1)
		pos=pos1
		for pos2 in range(pos1+1,Globals.posmax):
			Globals.tempcomps+=1
			if read_plot(pos2)<value:
				pos+=1
		if pos==pos1:
			continue
		while value==read_plot(pos):
			Globals.tempcomps+=1
			pos+=1
		temp=read_plot(pos)
		plot(pos,value)
		value=temp
		display.refresh()
		while pos!=pos1:
			Globals.tempcomps+=1
			pos=pos1
			for pos2 in range(pos1+1,Globals.posmax):
				Globals.tempcomps+=1
				if read_plot(pos2)<value:
					pos+=1
			while value==read_plot(pos):
				Globals.tempcomps+=1
				pos+=1
			temp=read_plot(pos)
			plot(pos,value)
			display.refresh()
			value=temp
			if Globals.key==curses.KEY_HOME:
				return

def doublebubblesort ():
	pos1=0
	pos2=Globals.posmax-1
	while pos1<pos2:
		key1=read_plot(pos1)
		for pos in range(pos2,pos1,-1):
			key=read_plot(pos)
			Globals.tempcomps+=1
			if key<key1:
				plot(pos1,key)
				plot(pos,key1)
				display.refresh()
				key1=key
			if Globals.key==curses.KEY_HOME:
				return
		pos1+=1
		key2=read_plot(pos2)
		for pos in range(pos1+1,pos2):
			key=read_plot(pos)
			Globals.tempcomps+=1
			if key>key2:
				plot(pos2,key)
				plot(pos,key2)
				display.refresh()
				key2=key
			if Globals.key==curses.KEY_HOME:
				return
		pos2-=1

def selectsort ():
	for pos0 in range(Globals.posmax-1):
		pos=pos0
		temp=read_plot(pos);
		for ps in range(pos0+1,Globals.posmax):
			Globals.tempcomps+=1
			if read_plot(ps)<temp:
				pos=ps
				temp=read_plot(pos)
		if pos>pos0:
			plot(pos,read_plot(pos0))
			plot(pos0,temp)
			display.refresh()
		if Globals.key==curses.KEY_HOME:
			return

def heapify (n,i):
	largest=i
	lf=2*i+1
	rt=lf+1
	Globals.tempcomps+=1
	if lf<n and read_plot(lf)>read_plot(largest):
		largest=lf
	Globals.tempcomps+=1
	if rt<n and read_plot(rt)>read_plot(largest):
		largest=rt
	Globals.tempcomps+=1
	if largest!=i:
		temp=read_plot(i)
		plot(i,read_plot(largest))
		plot(largest,temp)
		display.refresh()
		heapify(n,largest)

def heapsort ():
	for i in range(Globals.posmax//2-1,-1,-1):
		heapify(Globals.posmax,i)
		if Globals.key==curses.KEY_HOME:
			return
	for i in range(Globals.posmax-1,-1,-1):
		temp=read_plot(0)
		plot(0,read_plot(i))
		plot(i,temp)
		display.refresh()
		if Globals.key==curses.KEY_HOME:
			return
		heapify(i,0)

def shell_bubblesort ():
	skridt=1
	while skridt<Globals.posmax:
		skridt=skridt*Globals.shell_step+1
	while skridt>1:
		skridt=int(skridt/Globals.shell_step)
		display.addstr(Globals.lines+3,Globals.infopos,'Step: {:5}  '.format(skridt))
		slut=Globals.posmax-skridt
		byt=1
		while byt:
			byt=0
			for pos0 in range(slut):
				pos=pos0+skridt
				tmp1=read_plot(pos0)
				tmp2=read_plot(pos)
				Globals.tempcomps+=1
				if tmp1>tmp2:
					plot(pos,tmp1)
					plot(pos0,tmp2)
					display.refresh()
					byt=1
					if Globals.key==curses.KEY_HOME:
						return

def shell_insertsort ():
	skridt=1
	while skridt<Globals.posmax:
		skridt=skridt*Globals.shell_step+1
	while skridt>1:
		skridt=int(skridt/Globals.shell_step)
		display.addstr(Globals.lines+3,Globals.infopos,'Step: {:5}  '.format(skridt))
		for pos0 in range(skridt,Globals.posmax):
			tmp1=read_plot(pos0)
			pos=pos0-skridt
			while pos>=0 and read_plot(pos)>tmp1:
				Globals.tempcomps+=1
				plot(pos+skridt,read_plot(pos))
				display.refresh()
				pos-=skridt
				if Globals.key==curses.KEY_HOME:
					return
			pos+=skridt
			plot(pos,tmp1)
			display.refresh()

def mergesort (left,right):
	if right>left:
		m=(right+left)//2
		mergesort(left,m)
		mergesort(m+1,right)
		for lf in range(m,left-1,-1):
			Globals.merge_area[lf]=read_plot(lf)
		for rt in range(m+1,right+1):
			Globals.merge_area[right+m+1-rt]=read_plot(rt)
		lf=left
		rt=right
		for k in range(left,right+1):
			Globals.tempcomps+=1
			if Globals.key==curses.KEY_HOME:
				return
			if Globals.merge_area[lf]<=Globals.merge_area[rt]:
				plot(k,Globals.merge_area[lf])
				lf+=1
			else:
				plot(k,Globals.merge_area[rt])
				rt-=1
			display.refresh()

def quicksort (left,right):
	lf=left
	rt=right
	pivot=read_plot((lf+rt)//2)
	while lf<=rt:
		while read_plot(lf)<pivot:
			Globals.tempcomps+=1
			lf+=1
		while pivot<read_plot(rt):
			Globals.tempcomps+=1
			rt-=1
		if lf<=rt:
			temp=read_plot(rt)
			plot(rt,read_plot(lf))
			plot(lf,temp)
			display.refresh()
			lf+=1
			rt-=1
			if Globals.key==curses.KEY_HOME:
				return
	if left<rt:
		quicksort(left,rt)
	if lf<right:
		quicksort(lf,right)

def get_max ():
	mx=read_plot(0)
	for pos in range(1,Globals.posmax):
		Globals.tempcomps+=1
		val=read_plot(pos)
		if val>mx:
			mx=val
	return ord(mx)

def rad_count_sort (exp):
	output=[0]*Globals.posmax
	count=[0]*10
	for pos in range(Globals.posmax):
		count[(ord(read_plot(pos))//exp)%10]+=1
	for n in range(1,10):
		count[n]+=count[n-1]
	for pos in range(Globals.posmax-1,-1,-1):
		ch=read_plot(pos)
		val=ord(ch)
		output[count[(val//exp)%10]-1]=ch
		count[(val//exp)%10]-=1
	for pos in range(Globals.posmax):
		plot(pos,output[pos])
		display.refresh()
		if Globals.key==curses.KEY_HOME:
			return

def radixsort ():
	m=get_max()
	exp=1
	while m//exp:
		rad_count_sort(exp)
		display.refresh()
		exp*=10

def countsort ():
	counter=[0]*256
	for pos in range(Globals.posmax):
		Globals.tempcomps+=1
		counter[ord(read_plot(pos))]+=1
	pos=0
	for nr in range(256):
		for n in range(counter[nr]):
			plot(pos,chr(nr))
			display.refresh()
			pos+=1
			if Globals.key==curses.KEY_HOME:
				return

# ---------------- Interface ----------------

def menu ():
	display.nodelay(0)
	display.clear()
	display.addstr(1,0,'\tSort times:              Random   Pres. Asc.  Pres. Des.       Plots     Compares\n')
	for nr,name in enumerate(Globals.sort_names):
		ch=Globals.sort_keys[nr]
		display.addstr(' [{}]\t{:19}'.format(ch.upper(),name+'sort'))
		for ps in range(Globals.presorts):
			display.addstr('{:>12}'.format(Globals.sorttimes[nr][ps]))
		display.addstr('{:>13}'.format(Globals.plots[nr]))
		display.addstr('{:>13}\n'.format(Globals.compares[nr]))
	display.addstr('\n')
	display.addstr(display_signal())
	display.addstr(' [+/-]	Lines (1-{}): {:3}\n'.format(Globals.ymax,Globals.lines))
	display.addstr(' [Z]	Zero times, plots and compares\n\n')
	display.addstr(' [W]	Register window after resize - (min. {},{}): {},{}\n\n'.format(Globals.minx,Globals.miny,Globals.abs_xmax,Globals.abs_ymax))
	display.addstr(display_delay(1))
	display.addstr('\t[Up/Down]	increase/decrease delay ({:5.2f} msec)\n'.format(Char.delaysteps[0]/1e6))
	display.addstr('\t[Right/Left]	increase/decrease delay ({:5.2f} msec)\n'.format(Char.delaysteps[1]/1e6))
	display.addstr('\t[PgUp/PgDn]	increase/decrease delay ({:5.2f} msec)\n'.format(Char.delaysteps[2]/1e6))
	display.addstr('\t[Ins/Del]	increase/decrease delay ({:5.2f} msec)\n'.format(Char.delaysteps[3]/1e6))
	display.addstr('\t[0..9]	delay = [key]*{:.0f} msec\n\n'.format(Char.delaysteps[4]/1e6))
	display.addstr(' While sorting (if delay is set):\n')
	display.addstr('\t[P]	Pause sort\n')
	display.addstr('\t[Home]	Quit sort\n\n')
	display.addstr(' [Esc]	Quit program')
	display.refresh()

# ---------------- Main ----------------

display=init_screen()

key=0
while key!=Char.esc:
	menu()
	key=display.getch()
	display.clear()
	ch=chr(key)
	if ch in Globals.sort_keys:
		sort=Globals.sort_keys.index(ch)
		display.clear()
		display_info(sort)
		fill_screen()
		do_presort(Globals.presort)
		Globals.tempplots=Globals.tempcomps=0
		Globals.start=time.perf_counter_ns()
		display.nodelay(1)
		Globals.key=0
		if ch=='a':
			insertsort()
		if ch=='b':
			odd_even_sort()
		if ch=='c':
			cyclesort()
		if ch=='d':
			bubblesort()
		if ch=='e':
			doublebubblesort()
		if ch=='f':
			selectsort()
		if ch=='g':
			heapsort()
		if ch=='h':
			mergesort(0,Globals.posmax-1)
		if ch=='i':
			shell_bubblesort()
		if ch=='j':
			shell_insertsort()
		if ch=='k':
			quicksort(0,Globals.posmax-1)
		if ch=='l':
			radixsort()
		if ch=='m':
			countsort()
		if ch=='n':
			pass
		report_status()
	else:
		if ch=='w':
			curses.endwin()
			display=init_screen()
		if ch=='p':
			Globals.presort=(Globals.presort+1)%3
		if ch=='s':
			Globals.signal=(Globals.signal+1)%signals_max
		if ch in '+-':
			init_screendata(ch)
		if ch=='z':
			zero_data()
		if ch in Char.delay_keys:
			set_delay()

curses.endwin()
os.system('clear')
print(' Done')
