#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include <conio.h>

// #pragma warn -8057

#define windows.h_available // windows.h needed for the sound section.

#ifdef windows.h_available
	#include <windows.h>
	#define MY_PI 3.141593
	#define SAMPLE_RATE 22050
#endif
// #else: Skip compiling the sound code section.

// ---------------- Types ----------------

enum { ABSMAXLINES=62, MAXSIZE=230*(ABSMAXLINES+1) };
typedef unsigned char byte;
typedef enum {false, true} bool;
typedef byte help_type[MAXSIZE];
struct collection {
	int limitx,lines,maxlines,absmax,datasize;
	int plots,compares;
	int soundtype;
	float duration;
	bool home,paused,sortpause;
	unsigned int lrstep,dustep,pgstep,numstep;
};

// ---------------- Constants ----------------

enum { MAXSORTS=25, STARTX=3, STARTY=3 };
enum { NAMEPOS=25, TIMESPOS=28, INFOPOS=50 };
enum { DELAYMAX=4000000000, ESC=27 };
float shell_step=1.3;


static char *pretype[3] = {"No","Ascending","Descending"}; // Presort
static int soundtypes[] = {0,500,5000};
static char *onoff[] = {"No ","Yes"};
static char alphabet[] = "abcdefghijklmnopqrstuvxyz";

static char *sort_names[] = {
	"Odd-Even",
	"Insert",
	"Bubble",
	"DoubleBubble",
	"Heap",
	"Shell(insert)",
	"Merge",
	"Shell(Bubble)",
	"Quick",
	"Radix",
	"Select",
	"Cycle",
	"Count",
	"No ",
};
// Remember:
const int sorts=sizeof(sort_names)/sizeof(sort_names[0]);

enum {
  left  = 331,
  right = 333,
  up    = 328,
  down  = 336,
  pgup  = 329,
  pgdn  = 337,
	ins   = 338,
	del   = 339,
  home  = 327,
  eend  = 335,
};

// Language is English:
static char thousep='\'', decpoint='.';

// ---------------- Variables ----------------

help_type sortdata, screendata, merge_area;

unsigned int delay=0;
int presort=0;
char sorttimes[MAXSORTS][3][20],plots[MAXSORTS][20],compares[MAXSORTS][20];
struct collection global;

int microsecond = 38700;
char delaystring[20];

// ---------------- Sound ----------------

#ifdef windows.h_available
/* The two 'unused' variables are used by the system call. */
void CALLBACK CallBackProc (HWAVEOUT hwo, UINT uMsg, DWORD XdwInstance, DWORD dwParam1, DWORD XdwParam2) {
	if (uMsg==WOM_DONE) {
		MMRESULT MMResult;
		WAVEHDR *WaveHeader=(WAVEHDR *)dwParam1;
		if ((MMResult=waveOutUnprepareHeader(hwo, WaveHeader, sizeof(WAVEHDR)))!=MMSYSERR_NOERROR) {
			char Text[256];
			waveOutGetErrorText(MMResult, Text, sizeof(Text));
			printf("Failed to unprepare: %sn", Text);
		}
		free(WaveHeader->lpData);
	}
}

bool sound (int freq, int duration) {
	HWAVEOUT WaveHandle;
	WAVEFORMATEX WaveFormat;
	WAVEHDR WaveHeader;
	MMRESULT MMResult;
	char *buffer=(char *)malloc(SAMPLE_RATE*duration/1000);
	float factor=2.0*MY_PI*freq/SAMPLE_RATE;
	clock_t tid;
	int x;

	for (x=0; x<SAMPLE_RATE*duration/1000; ++x)
		buffer[x]=(char)(128.0+(127.0*sin(factor*x)));
	WaveFormat.wFormatTag = WAVE_FORMAT_PCM;
	WaveFormat.nChannels = 1;
	WaveFormat.nSamplesPerSec = SAMPLE_RATE;
	WaveFormat.nAvgBytesPerSec = SAMPLE_RATE;
	WaveFormat.nBlockAlign = 1;
	WaveFormat.wBitsPerSample = 8;
	WaveFormat.cbSize = 0;
	if (waveOutOpen(&WaveHandle, WAVE_MAPPER, &WaveFormat, (DWORD)CallBackProc, 0, CALLBACK_FUNCTION) != MMSYSERR_NOERROR) {
		printf("Failed to open Wave!n");
		return false;
	}
	memset(&WaveHeader, 0, sizeof(WaveHeader));
	WaveHeader.lpData = buffer;
	WaveHeader.dwBufferLength = duration*SAMPLE_RATE/1000;
	WaveHeader.dwBytesRecorded = duration*SAMPLE_RATE/1000;
	WaveHeader.dwLoops = 1;
	WaveHeader.dwFlags = WHDR_BEGINLOOP | WHDR_ENDLOOP;
	if (waveOutPrepareHeader(WaveHandle, &WaveHeader, sizeof(WaveHeader)) != MMSYSERR_NOERROR) {
		printf("Failed to prepare header!n");
		return false;
	}
	if ((MMResult = waveOutWrite(WaveHandle, &WaveHeader, sizeof(WaveHeader))) != MMSYSERR_NOERROR) {
		char Text[256];
		waveOutGetErrorText(MMResult, Text, sizeof(Text));
		printf("Failed to write: %sn", Text);
		return false;
	}
	Sleep(duration);
	while (!(WaveHeader.dwFlags & WHDR_DONE)) Sleep(10);
	if ((MMResult = waveOutClose(WaveHandle)) != MMSYSERR_NOERROR) {
		char Text[256];
		waveOutGetErrorText(MMResult, Text, sizeof(Text));
		printf("Failed to close: %sn", Text);
		return false;
	}
	return true;
}
#endif

// ---------------- Utilities ----------------

void calibrate_timer (void) {
	long start,t0,t,t2,ms;
	float error;
	int used=0,step=100;
	printf(" Calibrating delay timer - wait 15 seconds ... ");
	for (t0=0; t0<1000; t0+=step) {
		if (used>500)
			step=10;
		if (used>930)
			step=1;
		start=clock();
		for (t=0; t<t0; ++t)
			for (t2=0; t2<10000000; ++t2);
		used=clock()-start;
		if (used>999)
			break;
	}
	printf("finished.\n");
	ms=t0*100;
	error=ms/microsecond*100;
	if (error<1) {
		printf(" The present value is acceptable.\n",ms);
		return;
	}
	printf(" Enter this line in the code: \"int microsecond = %d;\"\n",ms);
	microsecond=ms;
}

void pause (void) {
	if (getch()==ESC)
		exit(5);
}

void wait_menu (void) {
	gotoxy(INFOPOS,1);
	textattr(224);
	cprintf(" Press [Space] ");
	while (getch()!=' ');
	system("cls");
}

int getwch (void) {
	static int ch;
	ch=getch();
	if (!ch)
		ch=getch()+256;
	return ch;
}

int rand_number (void) {
	float factor = 223.0/RAND_MAX;
	return (int) (factor*rand())+33;
}

int FILTERED_rand_number (void) {
	//  is removed because it causes strange results in combination with printf() - or whatever ...
	// or does it? The straight routine is now the active one.
	static float factor = 223.0/RAND_MAX;
	int temp=146;
	while (temp==146)
		temp=(int) (factor*rand())+33;
	return temp;
}

void format (double x, char *result, int d) {
	static int rest;
	static char buffer[30], *p1, *p2, *dot;
	static bool separate;
	sprintf(buffer,"%.3f",x);
	dot=strchr(buffer,'.');
	*dot=0;
	rest=strlen(buffer)%3;
	*dot=decpoint;
  p1=buffer;
 	p2=result;
	*p2++=*p1++;
	separate=1;
	while (*p1) {
		if (*p1==decpoint)
			separate=0;
		if (separate && (p1-buffer)%3==rest)
			*p2++=thousep;
		*p2++=*p1++;
	}
	*p2=*p1;
	if (!d)
		*strchr(result,decpoint)=0;
}

void delay_format (char string[], unsigned int dl) {
	if (dl)
		sprintf(string,"%.2f msec",.01*dl/microsecond);
	else
		sprintf(string,"0");
}

int delay_routine (void) {
	unsigned int ch, n;
	double timer;
	if (kbhit()) {
		ch=getwch();
		if (ch==home) {
			global.paused=1;
			global.home=1;
			return home;
		}
		if (ch=='p') {
			textattr(224);
			gotoxy(INFOPOS,1);
			cprintf("   Pause   ");
			while (getwch()==ESC);
			gotoxy(INFOPOS,1);
			printf("            ");
			global.paused=1;
		}
	}
	for (n=0; n<delay; ++n);
	return ' ';
}

void plot (int pos) {
	static int x, y;
	x=pos%global.limitx+STARTX;
	y=pos/global.limitx+STARTY;
	gotoxy(x,y);
	printf("%c",screendata[pos]);
	global.plots+=1;
}

// ---------------- Timing and report ----------------

void zero_results (void) {
	int sort, ps;
	for (sort=0; sort<sorts; ++sort) {
		sprintf(plots[sort],"0");
		sprintf(compares[sort],"0");
		for (ps=0; ps<3; ++ps)
			sprintf(sorttimes[sort][ps],".000");
	}
}

void format_time (double sec,char *result) {
	double h,m;
	h=floor(sec/3600);
	sec-=h*3600;
	m=floor(sec/60);
	sec-=m*60;
	if (h)
		sprintf(result,"%.0f:%02.0f:%06.3f",h,m,sec);
	else if (m)
		sprintf(result,"%2.0f:%06.3f",m,sec);
	else
		sprintf(result,"%6.3f",sec);
}

void report_status (double tid, byte sort) {
	char plot_res[20],comp_res[20];
	float usedtime;
	char prettytime[30];
	usedtime=(clock()-tid)/1000.0;
	format(usedtime,prettytime,1);
	gotoxy(STARTX,1);
	printf("Time %s sec.     ",prettytime);
	format(global.plots,plot_res,0);
	gotoxy(STARTX,global.lines+4);
	printf("Number of plots:    %s",plot_res);
	format(global.compares,comp_res,0);
	printf("\t\tNumber of compares: %s",comp_res);
	if (!global.paused) {
		format_time(usedtime,sorttimes[sort][presort]);
		sprintf(plots[sort],plot_res);
		sprintf(compares[sort],comp_res);
	}
#ifdef windows.h_available
	if (global.duration &&!global.home)
		sound(1000,global.duration);
#endif
}

// ---------------- Presort ----------------

void do_presort (void) { // Selectsort
	int pos0,pos,ps,temp;
	if (!presort)
		return;
	for (pos0=0; pos0<global.datasize-1; ++pos0) {
		pos=pos0;
		temp=screendata[pos];
		if (presort==1)
			for (ps=pos0+1; ps<global.datasize; ++ps)
				if (screendata[ps]<temp) {
					pos=ps;
					temp=screendata[pos];
				}
		if (presort==2)
			for (ps=pos0+1; ps<global.datasize; ++ps)
				if (screendata[ps]>temp) {
					pos=ps;
					temp=screendata[pos];
				}
		if (pos>pos0) {
			screendata[pos]=screendata[pos0];
			screendata[pos0]=temp;
		}
	}
}

// ---------------- Sorting ----------------

void odd_even_sort (void) {
	int byt=1, begin, pos, temp;
	while (byt) {
		byt=0;
		for (begin=1; begin>=0; --begin) {
			for (pos=begin; pos<global.datasize-1; pos+=2) {
				++global.compares;
				if (screendata[pos]>screendata[pos+1]) {
					temp=screendata[pos];
					screendata[pos]=screendata[pos+1];
					screendata[pos+1]=temp;
					plot(pos);
					plot(pos+1 );
					byt=1;
				}
				if (delay && delay_routine()==home)
					return;
			}
		}
	}
}


void bubblesort (void) {
	int pos0,pos,key0,key;
	for (pos0=0; pos0<global.datasize-1; ++pos0) {
		key0=screendata[pos0];
		for (pos=pos0+1; pos<global.datasize; ++pos) {
			key=screendata[pos];
			if (++global.compares && key<key0) {
				screendata[pos0]=key;
				screendata[pos]=key0;
				key0=screendata[pos0];
				plot(pos0);
				plot(pos);
				if (delay && delay_routine()==home)
					return;
			}
		}
	}
}


void insertsort (void) {
	int pos0,pos,key;
	for (pos0=1; pos0<global.datasize; ++pos0) {
		key=screendata[pos0];
		pos=pos0-1;
		while (++global.compares && pos>=0 && screendata[pos]>key) {
			screendata[pos+1]=screendata[pos];
			plot(pos+1);
			--pos;
			if (delay && delay_routine()==home)
				return;
		}
		screendata[++pos]=key;
		plot(pos);
	}
}


void shell_bubblesort (void) {
	int pos0,pos,slut,byt,tmp1,tmp2,skridt=1;
	do {
		skridt=skridt*shell_step+1;
	} while (skridt<=global.datasize);
	while (skridt>1) {
		skridt=skridt/shell_step;
		gotoxy(INFOPOS,1);
		printf("Step:%5d    ",skridt);
		if (global.sortpause)
			pause();
		slut=global.datasize-skridt;
		do {
			byt=0;
			for (pos0=0; pos0<slut; ++pos0) {
				pos=pos0+skridt;
				tmp1=screendata[pos0];
				tmp2=screendata[pos];
				if (++global.compares && tmp1>tmp2) {
					screendata[pos]=tmp1;
					screendata[pos0]=tmp2;
					plot(pos);
					plot(pos0);
					byt=1;
					if (delay && delay_routine()==home)
						return;
				}
			}
		} while (byt);
  }
}


void shell_insertsort (void) {
	float shell_step=3.5;
	int pos0,pos,skridt=1,tmp1;
	do {
		skridt=skridt*shell_step+1;
	} while (skridt<=global.datasize);
	while (skridt>1) {
		skridt=skridt/shell_step;
		gotoxy(INFOPOS,1);
		printf("Step:%5d    ",skridt);
		if (global.sortpause)
			pause();
		for (pos0=skridt; pos0<global.datasize; ++pos0) {
			tmp1=screendata[pos0];
			pos=pos0-skridt;
			while (++global.compares && pos>=0 && screendata[pos]>tmp1) {
				screendata[pos+skridt]=screendata[pos];
				plot(pos+skridt);
				pos-=skridt;
				if (delay && delay_routine()==home)
					return;
			}
			pos+=skridt;
			screendata[pos]=tmp1;
			plot(pos);
		}
	}
}


void cyclesort (void) {
	int pos1,value,pos,pos2, temp;
	for (pos1=0; pos1<global.datasize-1; ++pos1) {
		value=screendata[pos1];
		pos=pos1;
		for (pos2=pos1+1; pos2<global.datasize; ++pos2) {
			global.compares+=1;
			if (screendata[pos2]<value)
				++pos;
		}
		if (pos==pos1)
			continue;
		while (value==screendata[pos]) {
			global.compares+=1;
			pos+=1;
		}
		temp=screendata[pos];
		screendata[pos]=value;
		plot(pos);
		value=temp;
		while (pos!=pos1) {
			++global.compares;
			pos=pos1;
			for (pos2=pos1+1; pos2<global.datasize; ++pos2) {
				++global.compares;
				if (screendata[pos2]<value)
					++pos;
			}
			while (value==screendata[pos]) {
				++global.compares;
				++pos;
			}
			temp=screendata[pos];
			screendata[pos]=value;
			plot(pos);
			value=temp;
			if (delay && delay_routine()==home)
				return;
		}
	}
}


void double_bubblesort (void) {
	int pos1=0,pos2=global.datasize-1,pos,key,key1,key2;
	while (pos1<pos2) {
		key1=screendata[pos1];
		for (pos=pos2-1; pos>pos1; --pos) {
			key=screendata[pos];
			++global.compares;
			if (key<key1) {
				screendata[pos1]=key;
				screendata[pos]=key1;
				plot(pos);
				plot(pos1);
				key1=key;
			}
		}
		if (delay && delay_routine()==home)
			return;
		++pos1;
		key2=screendata[pos2];
		for (pos=pos1+1; pos<pos2; ++pos) {
			key=screendata[pos];
			++global.compares;
			if (key>key2) {
				screendata[pos2]=key;
				screendata[pos]=key2;
				key2=key;
				plot(pos);
				plot(pos2);
			}
		}
		if (delay && delay_routine()==home)
			return;
		--pos2;
	}
}


void selectsort (void) {
	int pos0,pos,ps,temp;
	for (pos0=0; pos0<global.datasize-1; ++pos0) {
		pos=pos0;
		temp=screendata[pos];
		for (ps=pos0+1; ps<global.datasize; ++ps)
			if (++global.compares && screendata[ps]<temp) {
				pos=ps;
				temp=screendata[pos];
			}
		if (pos>pos0) {
			screendata[pos]=screendata[pos0];
			screendata[pos0]=temp;
			plot(pos0);
			plot(pos);
		}
		if (delay && delay_routine()==home)
			return;
	}
}


void heapify (int n, int i) {
	int largest,lf,rt;
	byte temp;
	if (delay && delay_routine()==home)
		return;
	largest=i;
	lf=2*i+1;
	rt=lf+1;
	if (++global.compares && lf<n && screendata[lf]>screendata[largest])
		largest=lf;
	if (++global.compares && rt<n && screendata[rt]>screendata[largest])
		largest=rt;
	if (largest!=i) {
		temp=screendata[i];
		screendata[i]=screendata[largest];
		screendata[largest]=temp;
		plot(i);
		plot(largest);
		heapify(n,largest);
	}
}

void heapsort (void) {
	int pos;
	byte temp;
	for (pos=global.datasize/2-1; pos>=0; --pos)
		heapify(global.datasize,pos);
	for (pos=global.datasize-1; pos>=0; --pos) {
		temp=screendata[0];
		screendata[0]=screendata[pos];
		screendata[pos]=temp;
		plot(0);
		plot(pos);
		if (global.home)
			return;
		heapify(pos,0);
	}
}


void mergesort (int left, int right) {
	int lf, rt, k, m;
	if (global.home) // Otherwise you can only return once inside deep levels of the routine.
		return;
	if (right>left) {
		m=(right+left)/2;
		mergesort(left,m);
		mergesort(m+1,right);
		for (lf=m; lf>=left; --lf)
			merge_area[lf]=screendata[lf];
		for (rt=m+1; rt<=right; ++rt)
			merge_area[right+m+1-rt]=screendata[rt];
		lf=left;
		rt=right;
		for (k=left; k<=right; ++k){
			if (++global.compares && merge_area[lf]<=merge_area[rt]) {
				screendata[k]=merge_area[lf];
				++lf;
			}
			else {
				screendata[k]=merge_area[rt];
				--rt;
			}
			plot(k);
			if (delay && delay_routine()==home)
				return;
		}
	}
}


void quicksort (int left, int right) {
	int lf, rt;
	byte pivot,temp;
	lf=left;
	rt=right;
	pivot=screendata[(lf+rt)/2];
	do {
		while (++global.compares && screendata[lf]<pivot)
			++lf;
		while (++global.compares && pivot<screendata[rt])
			--rt;
		if (lf<=rt) {
			temp=screendata[rt];
			screendata[rt]=screendata[lf];
			screendata[lf]=temp;
			plot(lf);
			plot(rt);
			++lf;
			--rt;
			if (delay && delay_routine()==home)
				return;
		}
	} while (lf<=rt);
	if (left<rt)
		quicksort(left,rt);
	if (lf<right)
		quicksort(lf,right);
}


byte get_max (void) {
	int pos,mx=screendata[0];
	for (pos=1; pos<global.datasize; pos++)
		if (++global.compares && screendata[pos]>mx)
			mx=screendata[pos];
	return mx;
}

void rad_count_sort (int exp) {
	int output[MAXSIZE];
	int pos, count[10]={0};
	for (pos=0; pos<global.datasize; ++pos)
		count[(screendata[pos]/exp)%10]++;
	for (pos=1; pos<10; ++pos)
		count[pos]+=count[pos-1];
	for (pos=global.datasize-1; pos>=0; --pos) {
		output[count[(screendata[pos]/exp)%10 ]-1]=screendata[pos];
		count[(screendata[pos]/exp)%10]--;
	}
	for (pos=0; pos<global.datasize; ++pos) {
		screendata[pos]=output[pos];
		plot(pos);
		if (delay && delay_routine()==home)
			return;
	}
}

void radixsort (void) {
	int m,exp;
	m=get_max();
	for (exp=1; m/exp; exp*=10) {
		rad_count_sort(exp);
		if (global.sortpause)
			pause();
	}
}


void countsort (void) {
	int counter[256];
	int pos, nr, n;
	for (n=0; n<256; ++n)
		counter[n]=0;
	for (pos=0; pos<global.datasize; ++pos) {
		counter[screendata[pos]]++;
		++global.compares;
	}
	pos=0;
	for (nr=0; nr<256; ++nr)
		for (n=0; n<counter[nr]; ++n) {
			screendata[pos]=nr;
			plot(pos++);
			if (delay && delay_routine()==home)
				return;
		}
}

// ---------------- Interface ----------------

void menu (void) {
	char disp_lr[20],disp_du[20],disp_pg[20],disp_num[20];
	byte sort,ps;
	delay_format(delaystring,delay);
	delay_format(disp_lr,global.lrstep);
	delay_format(disp_du,global.dustep);
	delay_format(disp_pg,global.pgstep);
	delay_format(disp_num,global.numstep);
	gotoxy(1,2);
	printf("\tSort times:");
	gotoxy(TIMESPOS+6,2);
	printf("%s%13s%12s%12s","Random","Pres. Asc.","Pres. Des.","Plots");
	if (global.limitx>80)
		printf("%13s","Compares");
	printf("\n");
	for (sort=0; sort<sorts-1+1; ++sort) {
		printf(" [%c]\t%ssort",sort+'A',sort_names[sort]);
		gotoxy(TIMESPOS,wherey());
		for (ps=0; ps<3; ++ps)
			printf("%12s",sorttimes[sort][ps]);
		printf("%13s",plots[sort]);
		if (global.limitx>80)
			printf("%13s",compares[sort]);
		printf("\n");
	}
	printf("\n [P]	Presort: %-10s\n",pretype[presort]);
#ifdef windows.h_available
	printf(" [S]	Sound: ");
	switch (global.soundtype) {
		case 0: printf("%-40s\n","No sound"); break;
		case 1: printf("%.1f sec.\n",global.duration/1000); break;
		case 2: printf("%.1f sec. (Wake up sleepy loudspeakers!)\n",global.duration/1000); break;
	}
#endif
	printf(" [+/-]	Lines (1-%d): %3d\n",global.maxlines,global.lines);
	printf(" [Z]	Zero times, plots and compares\n");
	printf(" [Ctrl-P]	Pause Shellsorts and Radixsort between steps: %s\n",onoff[global.sortpause]);
	printf(" [T]	Calibrate timer\n");
	printf("\n Delay: %-13s\n",delaystring);
	printf("	[LT/RT]		decrease/increase delay (%s)\n",disp_lr);
	printf("	[DN/UP]		decrease/increase delay (%s)\n",disp_du);
	printf("	[PgDn/PgUp]	decrease/increase delay (%s)\n",disp_pg);
	printf("	[0..9]		delay = [key]*%s\n",disp_num);
	printf("\n While sorting:\n");
	printf(" 	[P]	Pause sort\n");
	printf("\n 	[Home]	Quit sort\n");
	printf(" [Esc]	Quit program\n\n");
}

// ---------------- Init ----------------

void init_data (int ch) {
	int pos;
	switch (ch) {
		case '+':
			if (global.lines<global.maxlines)
				++global.lines;
				break;
		case '-':
			if (global.lines>1)
				--global.lines;
				break;
	}
	global.datasize=global.limitx*global.lines;
	for (pos=0; pos<global.datasize; ++pos)
		sortdata[pos]=rand_number();
}

void init (void) {
	int pos;
	byte sort,ps;
	struct text_info screen;

	system("cls");
 	gettextinfo(&screen);
	global.limitx=screen.winright-4;
	global.maxlines=ABSMAXLINES;
/* screen.winbottom aflser det linjeantal der er sati i genvejen - ikke den aktuelle strrelse.
	global.maxlines=screen.winbottom-5;
	if (global.maxlines>ABSMAXLINES)
		global.maxlines=ABSMAXLINES;
*/
	global.lrstep=microsecond*10;
	global.dustep=global.lrstep*10;
	global.pgstep=global.dustep*10;
	global.numstep=global.pgstep*10;
	global.lines=55;
	global.duration=soundtypes[global.soundtype=1];
	init_data(0);
	zero_results();
	_setcursortype(_NOCURSOR);
}

void init_screendata (void) {
	int pos;
	system("cls");
	for (pos=0; pos<global.datasize; ++pos)
		screendata[pos]=sortdata[pos];
	do_presort();
	for (pos=0; pos<global.datasize; ++pos)
		plot(pos);
	global.plots=global.compares=0;
	gotoxy(STARTX,1);
	printf("Delay: %-13s\n",delaystring);
	gotoxy(INFOPOS,1);
	printf("Quit: [Home]");
}

// ---------------- Main ----------------

int main (void) {
	int ch, c;
	byte sort;
	double tid;
	char limit;
	void *f;

	init();
	do {
		menu();
		ch=getwch();
		limit=alphabet[sorts];
		if ('a'<=ch && ch<limit) {
			sort=ch-'a';
			init_screendata();
			gotoxy(NAMEPOS,1);
			printf("%ssort",sort_names[sort]);
			global.home=global.paused=0;
			tid=clock();
			switch (sort) {
				case  0: odd_even_sort(); break;
				case  1: insertsort(); break;
				case  2: bubblesort(); break;
				case  3: double_bubblesort(); break;
				case  4: heapsort(); break;
				case  5: shell_insertsort(); break;
				case  6: mergesort(0,global.datasize-1); break;
				case  7: shell_bubblesort(); break;
				case  8: quicksort(0,global.datasize-1); break;
				case  9: radixsort(); break;
				case 10: selectsort(); break;
				case 11: cyclesort(); break;
				case 12: countsort(); break;
				case 13: break; // No sort
			}
			if (sort<sorts)
				report_status(tid,sort);
			wait_menu();
	  }
		else {
			switch (ch) {
				case left: if (delay>=global.lrstep)
					delay-=global.lrstep;
					break;
				case right: delay+=global.lrstep;
					break;
				case up: delay+=global.dustep;
					break;
				case down: if (delay>=global.dustep)
					delay-=global.dustep;
					break;
				case pgup: delay+=global.pgstep;
					break;
				case pgdn: if (delay>=global.pgstep)
					delay-=global.pgstep;
					break;
				case '0': case '1': case '2': case '3': case '4': case '5': case '6': case '7': case '8':
				case '9': delay=global.numstep*(ch-'0'); break;
				case 'p': presort=(++presort)%3; break;
				case 's': {
					global.soundtype=(++global.soundtype)%3;
					global.duration=soundtypes[global.soundtype];
					break;
				}
				case 16: global.sortpause=1-global.sortpause; break;
				case 'z': zero_results(); break;
				case 't': calibrate_timer(); break;
				case '+':
				case '-': init_data(ch); break;
			}
			if (delay>DELAYMAX)
				delay=DELAYMAX;
		}
  } while (ch!=ESC);

	return 0;
}

