import locale
locale.setlocale(locale.LC_ALL, '')
import curses
import random
import time
import winsound
import msvcrt

# ---------------- Globals ----------------

class Char:
	left   = chr(299)
	right  = chr(301)
	up     = chr(296)
	down   = chr(304)
	pgup   = chr(297)
	pgdn   = chr(305)
	insert = chr(306)
	delete = chr(307)
	home   = chr(295)
	eend   = chr(303)
	ctrl_p =  chr(16)
	esc    =  chr(27)
	digits = '0123456789'
	delayadd = right+up+pgup+insert
	delaysub = left+down+pgdn+delete
	delay_keys = delayadd+delaysub+digits
	delaysteps = [1e4,1e5,1e6,1e7,1e8]

class Globals:
	delay = 0
	xmin = 0
	ymin = 0
	xmax = 0
	ymax = 0
	lines = 0
	posmax = 0
	tempcomps = 0
	tempplots = 0
	start = 0
	presort = 0
	shell_step = 1.45
	presort_type = ['Random','Ascending','Descending']
	presorts = len(presort_type)

	sort_names = [
	'Odd-Even',
	'Bubble',
	'Insert',
	'Cycle',
	'DoubleBubble',
	'Select',
	'Heap',
	'Shell(Bubble)',
	'Merge',
	'Shell(insert)',
	'Quick',
	'Radix',
	'Count',
	'No ',
	]
	sort_keys  = 'abcdefghijklmnopqrstuvwxyz'[:len(sort_names)]
	sorts      = len(sort_keys)
	sorttimes  = []
	plots    = [0]*sorts
	compares = [0]*sorts

	namepos   = 25
	infopos   = 50
	prepos    = 70

	duration  = [0,800,5000]
	sound = 1

# ---------------- Functions ----------------

def pause ():
	print(' Pause ...')
	ch=msvcrt.getch()
	if ch==Char.esc:
		exit(2)

def getch (wait=0):
	if msvcrt.kbhit() or wait:
		ch=ord(msvcrt.getch())
		if msvcrt.kbhit():
			ch+=ord(msvcrt.getch())
		return chr(ch)
	return ''

def wait_menu (leave=0):
	winsound.Beep(1000,Globals.duration[Globals.sound])
	if Globals.xmax>=Globals.infopos:
		display.addstr(0,Globals.infopos,' Press [Space] ',curses.A_REVERSE)
		display.refresh()
	ch=''
	while ch!=' ':
		ch=getch(1)
		if ch==Char.ctrl_p:
			presort(1) # If this changes the screen - the sort failed!
	if leave:
		display.clear()
		return
	if Globals.xmax<Globals.infopos:
		return
	display.addstr(0,Globals.infopos,'Quit: [Home]')
	display.refresh()

def sec_format (nasec):
	return '{:.3f} sec.'.format(nasec/1000000000)

def display_delay (menu=0):
	if Globals.delay:
		return ' Delay: {:.2f} msec\n'.format(Globals.delay/1e6)
	if menu:
		return ' Delay: 0 (No pause, no quit)\n'
	else:
		return ' Delay: 0\n'

def time_format (nasec):
	secs=nasec/1e9
	mins=secs//60
	secs%=60
	if mins:
		return '{:.0f}:{:06.3f}'.format(mins,secs)
	return '{:6.3f}'.format(secs)

def delay_routine ():
	timer=time.perf_counter_ns()
	while time.perf_counter_ns()-timer<Globals.delay:
		pass
	ch=getch()
	if ch==Char.home:
		return ch
	elif ch=='p':
		display.addstr(0,Globals.infopos,'   Pause    ',curses.A_REVERSE)
		display.refresh()
		while getch(1)!='p':
			pass
		display.addstr(0,Globals.infopos,'Quit: [Home]')
	return ''

def plot (pos,val):
	y=pos//Globals.xmax+2
	x=pos%Globals.xmax+2
	display.addstr(y,x,val)
	Globals.tempplots+=1

def read_plot (pos):
	y=pos//Globals.xmax+2
	x=pos%Globals.xmax+2
	return chr(display.inch(y,x))

# ---------------- Init ----------------

def init_screendata (ch=0):
	if ch=='+':
		if Globals.lines<Globals.ymax:
			Globals.lines+=1
	elif ch=='-':
		if Globals.lines>1:
			Globals.lines-=1
	xdif=Globals.xmax-Globals.xmin
	ydif=Globals.lines-Globals.ymin
	Globals.posmax=xdif*ydif

def init_screen (ch=0):
	display=curses.initscr()
	curses.curs_set(0)
	Globals.ymax,Globals.xmax=display.getmaxyx()
	Globals.xmax-=4
	Globals.ymax-=5
	Globals.lines=Globals.ymax
	init_screendata()
	return display

def fill_sortarray ():
#	random.seed(314159) # Use if each new run must use the same set of screen data.
# Once the script is running, the screen data set remains the same.
	sortarray=[]
	for pos in range(Globals.posmax):
		if random.random()>=.5:
			sortarray.append(chr(random.randrange(33,128)))
		else:
			sortarray.append(chr(random.randrange(160,256)))
	return sortarray

def fill_screen ():
	for pos in range(Globals.posmax):
		plot(pos,sortarray[pos])
	# Total mystery! - an unexplained questionmark must be removed.
	for y in range(2,Globals.ymax+2):
		display.addstr(y,Globals.xmax+2,' ')
	display.refresh()

def zero_data ():
	Globals.sorttimes=[]
	for y in range(Globals.sorts):
		temp=[]
		for x in range(Globals.presorts):
			temp.append('.000')
		Globals.sorttimes.append(temp)
	for sort in range(Globals.sorts):
		Globals.plots[sort]=0
		Globals.compares[sort]=0

def set_delay ():
	level=Char.delayadd.find(ch)
	if level>=0:
		Globals.delay+=Char.delaysteps[level]
		return
	level=Char.delaysub.find(ch)
	if level>=0:
		step=Char.delaysteps[level]
		if Globals.delay>=step:
			Globals.delay-=step
		return
	if ch in Char.digits:
		Globals.delay=Char.digits.index(ch)*Char.delaysteps[-1]

# ---------------- Display functions ----------------

def display_info (sort):
	display.addstr(0,2,display_delay())
	print(' Sort number: ',sort)
	if Globals.xmax>=Globals.namepos:
		display.addstr(0,Globals.namepos,Globals.sort_names[sort]+'sort')
	if (Globals.delay) and Globals.xmax>=Globals.infopos:
		display.addstr(0,Globals.infopos,'Quit: [Home]')
	if Globals.xmax>=Globals.prepos:
		display.addstr(0,Globals.prepos,'Presort: '+Globals.presort_type[Globals.presort])
	display.refresh()

def report_status ():
	tim=time_format(time.perf_counter_ns()-Globals.start)
	display.addstr(0,2,'Time: {:14}'.format(tim))
	plt='{:n}'.format(Globals.tempplots).replace(".","'")
	cop='{:n}'.format(Globals.tempcomps).replace(".","'")
	temp='Plots: {}     Compares: {}'.format(plt,cop)
	display.addstr(Globals.lines+3,2,temp)
	display.refresh()
	Globals.sorttimes[sort][Globals.presort]=tim
	Globals.plots[sort]=plt
	Globals.compares[sort]=cop
	wait_menu(1)

# ---------------- Sorting routines ----------------

def presort (ps): # Countsort
	if not ps:
		return
	counter=[0]*Globals.posmax
	for pos in range(Globals.posmax):
		counter[ord(read_plot(pos))]+=1
	pos=0
	if ps==1:
		for nr in range(256):
			for n in range(counter[nr]):
				plot(pos,chr(nr))
				pos+=1
	elif ps==2:
		for nr in range(255,-1,-1):
			for n in range(counter[nr]):
				plot(pos,chr(nr))
				pos+=1
	display.refresh()

def odd_even_sort ():
	byt=1
	while byt:
		byt=0
		for begin in [1,0]:
			for i in range(begin,Globals.posmax-1,2):
				Globals.tempcomps+=1
				if read_plot(i)>read_plot(i+1):
					temp=read_plot(i)
					plot(i,read_plot(i+1))
					plot(i+1,temp)
					byt=1
				if Globals.delay and delay_routine()==Char.home:
					return
			display.refresh()

def bubblesort ():
	for pos1 in range(Globals.posmax-1):
		key1=read_plot(pos1)
		for pos2 in range(pos1+1,Globals.posmax):
			key2=read_plot(pos2)
			Globals.tempcomps+=1
			if key2<key1:
				plot(pos1,key2)
				plot(pos2,key1)
				display.refresh()
				key1=key2
				if Globals.delay and delay_routine()==Char.home:
					return

def insertsort ():
	for pos0 in range(1,Globals.posmax):
		key=read_plot(pos0)
		pos=pos0-1
		while pos>=0 and read_plot(pos)>key:
			Globals.tempcomps+=1
			plot(pos+1,read_plot(pos))
			display.refresh()
			pos-=1
			if Globals.delay and delay_routine()==Char.home:
				return
		plot(pos+1,key)
		display.refresh()

def cyclesort ():
	for pos1 in range(Globals.posmax-1):
		value=read_plot(pos1)
		pos=pos1
		for pos2 in range(pos1+1,Globals.posmax):
			Globals.tempcomps+=1
			if read_plot(pos2)<value:
				pos+=1
		if pos==pos1:
			continue
		while value==read_plot(pos):
			Globals.tempcomps+=1
			pos+=1
		temp=read_plot(pos)
		plot(pos,value)
		value=temp
		display.refresh()
		while pos!=pos1:
			Globals.tempcomps+=1
			pos=pos1
			for pos2 in range(pos1+1,Globals.posmax):
				Globals.tempcomps+=1
				if read_plot(pos2)<value:
					pos+=1
			while value==read_plot(pos):
				Globals.tempcomps+=1
				pos+=1
			temp=read_plot(pos)
			plot(pos,value)
			value=temp
			display.refresh()
			if Globals.delay and delay_routine()==Char.home:
				return

def cocktailsort ():
	pos1=0
	pos2=Globals.posmax-1
	while pos1<pos2:
		key1=read_plot(pos1)
		for pos in range(pos2-1,pos1,-1):
			key=read_plot(pos)
			Globals.tempcomps+=1
			if key<key1:
				plot(pos1,key)
				plot(pos,key1)
				display.refresh()
				key1=key
		if Globals.delay and delay_routine()==Char.home:
			return
		pos1+=1
		key2=read_plot(pos2)
		for pos in range(pos1+1,pos2):
			key=read_plot(pos)
			Globals.tempcomps+=1
			if key>key2:
				plot(pos2,key)
				plot(pos,key2)
				display.refresh()
				key2=key
		if Globals.delay and delay_routine()==Char.home:
			return
		pos2-=1

def selectsort ():
	for pos0 in range(Globals.posmax-1):
		pos=pos0
		temp=read_plot(pos);
		for ps in range(pos0+1,Globals.posmax):
			Globals.tempcomps+=1
			if read_plot(ps)<temp:
				pos=ps
				temp=read_plot(pos)
		if pos>pos0:
			plot(pos,read_plot(pos0))
			plot(pos0,temp)
			display.refresh()
		if Globals.delay and delay_routine()==Char.home:
			return

def heapify (n,i):
	if Globals.delay and delay_routine()==Char.home:
		return
	largest=i
	lf=2*i+1
	rt=lf+1
	Globals.tempcomps+=1
	if lf<n and read_plot(lf)>read_plot(largest):
		largest=lf
	Globals.tempcomps+=1
	if rt<n and read_plot(rt)>read_plot(largest):
		largest=rt
	Globals.tempcomps+=1
	if largest!=i:
		temp=read_plot(i)
		plot(i,read_plot(largest))
		plot(largest,temp)
		display.refresh()
		heapify(n,largest)

def heapsort ():
	for i in range(Globals.posmax//2-1,-1,-1):
		heapify(Globals.posmax,i)
	for i in range(Globals.posmax-1,-1,-1):
		temp=read_plot(0)
		plot(0,read_plot(i))
		plot(i,temp)
		display.refresh()
		heapify(i,0)

def shell_bubblesort ():
	skridt=1
	while skridt<Globals.posmax:
		skridt=skridt*Globals.shell_step+1
	while skridt>1:
		skridt=int(skridt/Globals.shell_step)
		display.addstr(0,Globals.infopos,'Step: {:5}  '.format(skridt))
		slut=Globals.posmax-skridt
		byt=1
		while byt:
			byt=0
			for pos0 in range(slut):
				pos=pos0+skridt
				tmp1=read_plot(pos0)
				tmp2=read_plot(pos)
				Globals.tempcomps+=1
				if tmp1>tmp2:
					plot(pos,tmp1)
					plot(pos0,tmp2)
					display.refresh()
					byt=1
					if Globals.delay and delay_routine()==Char.home:
						return

def shell_insertsort ():
	skridt=1
	while skridt<Globals.posmax:
		skridt=skridt*Globals.shell_step+1
	while skridt>1:
		skridt=int(skridt/Globals.shell_step)
		display.addstr(0,Globals.infopos,'Step: {:5}  '.format(skridt))
		for pos0 in range(skridt,Globals.posmax):
			tmp1=read_plot(pos0)
			pos=pos0-skridt
			while pos>=0 and read_plot(pos)>tmp1:
				Globals.tempcomps+=1
				plot(pos+skridt,read_plot(pos))
				pos-=skridt
				display.refresh()
				if Globals.delay and delay_routine()==Char.home:
					return
			pos+=skridt
			plot(pos,tmp1)

def mergesort (left,right):
	if right>left:
		m=(right+left)//2
		mergesort(left,m)
		mergesort(m+1,right)
		for lf in range(m,left-1,-1):
			merge_area[lf]=read_plot(lf)
		for rt in range(m+1,right+1):
			merge_area[right+m+1-rt]=read_plot(rt)
		lf=left
		rt=right
		for k in range(left,right+1):
			Globals.tempcomps+=1
			if merge_area[lf]<=merge_area[rt]:
				plot(k,merge_area[lf])
				lf+=1
			else:
				plot(k,merge_area[rt])
				rt-=1
			display.refresh()
			if Globals.delay and delay_routine()==Char.home:
				return

def quicksort (left,right):
	lf=left
	rt=right
	pivot=read_plot((lf+rt)//2)
	while lf<=rt:
		while read_plot(lf)<pivot:
			Globals.tempcomps+=1
			lf+=1
		while pivot<read_plot(rt):
			Globals.tempcomps+=1
			rt-=1
		if lf<=rt:
			temp=read_plot(rt)
			plot(rt,read_plot(lf))
			plot(lf,temp)
			display.refresh()
			lf+=1
			rt-=1
			if Globals.delay and delay_routine()==Char.home:
				return
	if left<rt:
		quicksort(left,rt)
	if lf<right:
		quicksort(lf,right)

def get_max ():
	mx=read_plot(0)
	for pos in range(1,Globals.posmax):
		Globals.tempcomps+=1
		val=read_plot(pos)
		if val>mx:
			mx=val
	return ord(mx)

def rad_count_sort (exp):
	output=[0]*Globals.posmax
	count=[0]*10
	for pos in range(Globals.posmax):
		count[(ord(read_plot(pos))//exp)%10]+=1
	for n in range(1,10):
		count[n]+=count[n-1]
	for pos in range(Globals.posmax-1,-1,-1):
		ch=read_plot(pos)
		val=ord(ch)
		output[count[(val//exp)%10]-1]=ch
		count[(val//exp)%10]-=1
	for pos in range(Globals.posmax):
		plot(pos,output[pos])
		display.refresh()
		if Globals.delay and delay_routine()==Char.home:
			return

def radixsort ():
	m=get_max()
	exp=1
	while m//exp:
		rad_count_sort(exp)
		display.refresh()
		exp*=10

def countsort ():
	counter=[0]*256
	for pos in range(Globals.posmax):
		Globals.tempcomps+=1
		counter[ord(read_plot(pos))]+=1
	pos=0
	for nr in range(256):
		for n in range(counter[nr]):
			plot(pos,chr(nr))
			display.refresh()
			pos+=1
			if Globals.delay and delay_routine()==Char.home:
				return

# ---------------- Interface ----------------

def menu ():
	display.clear()
	display.addstr(1,0,'\tSort times:              Random   Pres. Asc.  Pres. Des.       Plots     Compares\n')
	for nr,name in enumerate(Globals.sort_names):
		ch=Globals.sort_keys[nr]
		display.addstr(' [{}]\t{:19}'.format(ch.upper(),name+'sort'))
		for ps in range(Globals.presorts):
			display.addstr('{:>12}'.format(Globals.sorttimes[nr][ps]))
		display.addstr('{:>13}'.format(Globals.plots[nr]))
		display.addstr('{:>13}\n'.format(Globals.compares[nr]))
	display.addstr('\n')
	try:
		display.addstr(' [P]	Presort: {}\n'.format(Globals.presort_type[Globals.presort]))
		display.addstr(' [S]	Sound duration: {:.1f} sec\n'.format(Globals.duration[Globals.sound]/1000))
		display.addstr(' [+/-]	Lines (1-{}): {:3}\n'.format(Globals.ymax,Globals.lines))
		display.addstr(' [Z]	Zero times, plots and compares\n\n')
		display.addstr(display_delay(1))
		display.addstr('\t[LT/RT]		decrease/increase delay ({:5.2f} msec)\n'.format(Char.delaysteps[0]/1e6))
		display.addstr('\t[DN/UP]		decrease/increase delay ({:5.2f} msec)\n'.format(Char.delaysteps[1]/1e6))
		display.addstr('\t[PgDn/PgUp]	decrease/increase delay ({:5.2f} msec)\n'.format(Char.delaysteps[2]/1e6))
		display.addstr('\t[Ins/Del]	decrease/increase delay ({:5.2f} msec)\n'.format(Char.delaysteps[3]/1e6))
		display.addstr('\t[0..9]		delay = [key]*{:.0f} msec\n\n'.format(Char.delaysteps[4]/1e6))
		display.addstr(' While sorting:\n')
		display.addstr('\t[P]	Pause sort\n')
		display.addstr('\t[Home]	Quit sort\n\n')
		display.addstr(' [Esc]	Quit program')
	except:
		pass
	display.refresh()

# ---------------- Main ----------------

print('\n Do you want to resize the screen? Do it and press a key.\n')
print(' A height less than {} lines will crash the script.'.format(len(Globals.sort_keys)+4))
print(' A width less than 80 characters will screw up the menu display,')
print(' but the sorting screen will be okay.')
getch(1)
display=init_screen()
sortarray=fill_sortarray()
zero_data()
merge_area=[0]*Globals.posmax
ch=0
while ch!=Char.esc:
	menu()
	display.clear()
	ch=getch(1)
	if ch in Globals.sort_keys:
		sort=Globals.sort_keys.find(ch)
		display.clear()
		display_info(sort)
		fill_screen()
		presort(Globals.presort)
		Globals.tempplots=Globals.tempcomps=0
		Globals.start=time.perf_counter_ns()
		if ch=='a':
			odd_even_sort()
		if ch=='b':
			bubblesort()
		if ch=='c':
			insertsort()
		if ch=='d':
			cyclesort()
		if ch=='e':
			cocktailsort()
		if ch=='f':
			selectsort()
		if ch=='g':
			heapsort()
		if ch=='h':
			shell_bubblesort()
		if ch=='i':
			mergesort(0,Globals.posmax-1)
		if ch=='j':
			shell_insertsort()
		if ch=='k':
			quicksort(0,Globals.posmax-1)
		if ch=='l':
			radixsort()
		if ch=='m':
			countsort()
		if ch=='n':
			pass
		report_status()
	else:
		if ch=='p':
			Globals.presort=(Globals.presort+1)%3
		if ch=='s':
			Globals.sound=(Globals.sound+1)%3
		if ch in '+-':
			init_screendata(ch)
		if ch=='z':
			zero_data()
		if ch in Char.delay_keys:
			set_delay()


